START:
	CLR.L	-(SP)			SUPER VISOR CALL
	MOVE.W	#$20,-(SP)
	TRAP	#1
	ADDQ.L	#6,SP
	MOVE.L	D0,OLDSSP
	LEA	OURSTACK,A7

	MOVEQ	#1,D7			NUMBER_OF_BYTES
	LEA	KEYBOARD_ON(PC),A0
	BSR 	IKBD

	MOVE.L	#TEXT,-(A7)
	MOVE.W	#9,-(A7)
	TRAP	#1
	ADD.L	#6,SP

	BSR	HBL_ON

	JSR	START_SONG
	BSET	#5,$FFFFFA09.W

MAIN_LOOP:
	TST.B	KEY_BUFFER+$39
	BEQ.S	MAIN_LOOP

*****************************************************************************
* THIS IS THE QUIT ROUTINE
*****************************************************************************

QUIT
	MOVE.W 	#$2700,SR		TURN OFF INTS
	BSR 	HBLOFF			RESET VALUES
	LEA 	$FFFF8800.W,A1		BLANK SOUNDCHIP
	MOVE.L 	#$8080000,(A1)
	MOVE.L 	#$9090000,(A1)
	MOVE.L 	#$A0A0000,(A1)
	MOVE.W 	#$2300,SR		TURN BACK ON INTS
	MOVEQ	#1,D7
	LEA	KEYBOARD_OFF(PC),A0
	BSR 	IKBD	
	MOVE.W	#1,-(SP)		SWITCH BACK TO MEDIUM RES
	MOVE.L	#-1,-(SP)
	MOVE.L	#-1,-(SP)
	MOVE.W	#5,-(SP)
	TRAP	#14
	ADD.L	#12,SP
	MOVE.L	OLDSSP,-(A7)		RESTORE STACK
	MOVE.W	#$20,-(SP)		AND PUT BACK INTO USER MODE
	TRAP	#1
	ADDQ.L	#6,SP

	ILLEGAL

******************************************************************************
* ROUTINE FOR SETTING UP OF GENERAL INTERRUPTS
******************************************************************************

HBL_ON
	MOVE.L 	$FFFF8200.W,OLD_PHYS
	MOVE.L 	$120.W,OLD_TB		SAVE INTERRUPTS
	MOVE.L 	$70.W,OLD_VBL
	MOVE.L 	$118.W,OLD_KEY
	MOVE.L	$68.W,OLDHBL
	MOVE.L	$114.W,OLD_TIMER_C
	MOVE.L	$20.W,OLD_PRIV
	MOVE.B 	$FFFFFA07.W,OLD_07
	MOVE.B 	$FFFFFA09.W,OLD_09
	MOVE.B 	$FFFFFA0F.W,OLD_0F
	MOVE.B 	$FFFFFA13.W,OLD_13
	MOVE.B 	$FFFFFA1B.W,OLD_1B
	MOVE.B	$FFFFFA17.W,OLD_17
	MOVE.B	$FFFFFA1D.W,OLD_1D
	MOVE.B	$FFFFFA1F.W,OLD_1F
	MOVE.B	$FFFFFA23.W,OLD_23
	MOVE.B	$FFFFFA15.W,OLD_15
	MOVE.B	$FFFFFA11.W,OLD_11
	MOVE.B	$FFFFFA0D.W,OLD_0D
	MOVE.L	USP,A0
	MOVE.L	A0,OLD_USP
	MOVE.L	$8.W,OLD_8
	MOVE.L	$C.W,OLD_C
	MOVE.L	$10.W,OLD_10
	MOVE.L	$20.W,OLD_20
	LEA	SERIOUS_ERROR(PC),A0
	MOVE.L	A0,$8.W
	MOVE.L	A0,$C.W
	MOVE.L	A0,$10.W
	MOVE.L	A0,$20.W
	AND.B 	#$DF,$FFFFFA09.W	THEN SET UP OURS
	AND.B 	#$FE,$FFFFFA07.W
	MOVE.L 	#NULL_B,$120.W		FIRST TIMER B
	MOVE.L 	#NULL_VBL,$70.W		FIRST VBL
	BCLR	#3,$FFFFFA17.W
	OR.B 	#1,$FFFFFA07.W
	OR.B 	#1,$FFFFFA13.W
	BCLR 	#6,$FFFFFA09.W		PUT IN OUR NEW 
	MOVE.L 	#KEY_VECTOR,$118.W	KEY VECTOR
	BSET 	#6,$FFFFFA09.W
	JSR	INSTALL_QUARTET
	MOVE.W	#$2300,SR
	RTS

**************************************************************************
* RESTORE ALL THE PREVIOUSLY STORED INTERRUPTS
**************************************************************************

HBLOFF	MOVE.W 	SR,-(SP)		TAKE OUT ALL OF OUR INTS
	MOVE.W 	#$2700,SR
	MOVE.B 	OLD_07(PC),$FFFFFA07.W
	MOVE.B 	OLD_09(PC),$FFFFFA09.W
	MOVE.B 	OLD_0F(PC),$FFFFFA0F.W
	MOVE.B 	OLD_13(PC),$FFFFFA13.W
	MOVE.B 	OLD_1B(PC),$FFFFFA1B.W
	MOVE.B	OLD_17(PC),$FFFFFA17.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_1F(PC),$FFFFFA1F.W
	MOVE.B	OLD_1D(PC),$FFFFFA1D.W
	MOVE.B	OLD_15(PC),$FFFFFA15.W
	MOVE.B	OLD_11(PC),$FFFFFA11.W
	MOVE.L	OLD_USP(PC),A0
	MOVE.L	A0,USP
	MOVE.B	#180,$FFFFFA23.W
	MOVE.L 	OLD_TB(PC),$120.W
	MOVE.L 	OLD_VBL(PC),$70.W
	MOVE.L 	OLD_KEY(PC),$118.W
	MOVE.L	OLDHBL(PC),$68.W
	MOVE.L	OLD_TIMER_C(PC),$114.W
	MOVE.L	OLD_PRIV(PC),$20.W
	MOVE.L 	OLD_PHYS(PC),$FFFF8200.W
	MOVE.L	OLD_8(PC),$8.W
	MOVE.L	OLD_C(PC),$C.W
	MOVE.L	OLD_10(PC),$10.W
	MOVE.L	OLD_20(PC),$20.W
	MOVE.W 	(SP)+,SR
	RTS

OLD_8:		DC.L	0
OLD_C:		DC.L	0
OLD_10:		DC.L	0
OLD_20:		DC.L	0
OLDSSP		DC.L	0		*OLDSTACK
OLD_PALETTE	DS.L	8		*OLD ST PALETTE
OLD_TB		DC.L	0
OLD_VBL		DC.L	0
OLD_KEY		DC.L	0
OLD_PHYS	DC.L	0
OLDHBL		DC.L	0
OLD_TIMER_C:	DC.L	0
OLD_PRIV:	DC.L	0
OLD_USP:	DC.L	0
OLD_07		DC.B	0
OLD_09		DC.B	0
OLD_0F		DC.B	0
OLD_13		DC.B	0
OLD_17		DC.B	0
OLD_1B		DC.B	0
OLD_1D		DC.B	0
OLD_1F		DC.B	0
OLD_23		DC.B	0
OLD_15		DC.B	0
OLD_0D		DC.B	0
OLD_11		DC.B	0
VBLIND		DC.B	0	
		EVEN

*****************************************************************************
* THIS IS WHERE ALL THE INTERRUPTS ARE KEPT!!
*****************************************************************************

KEY_VECTOR:				*THE NEW KEY VECTOR
	MOVE.L	A0,-(A7)
	MOVE.L 	D2,-(SP)
	LEA	KEY_VARIABLES(PC),A0
AND_AG:	MOVE.B 	$FFFFFC00.W,D2		
	BTST 	#7,D2			ANY CHARACTER WAITING?
	BEQ.S	VECTOREND		NO THEN END
	MOVEQ	#0,D2
	MOVE.B 	$FFFFFC02.W,D2		READ CHARACTER INTO  'KBUFF'
	TST.W	(A0)
	BNE.S	JOY_PACKAGE1		GET THE JOYSTICK PACK FOR PORT 0
	TST.W	2(A0)
	BNE.S	JOY_PACKAGE2		GET THE JOYSTICK PACK FOR PORT 1
	CMP.B	#$FE,D2
	BEQ.S	JOY1
	CMP.B	#$FF,D2			IS IT A JOYSTICK PACKAGE
	BNE.S	NORMAL_KEY
	ST	(A0)
	BRA.S	AND_AG
	
NORMAL_KEY:
	TST.B	D2			KEY PRESSED
	BPL.S	.SET_KEY
.CLR_KEY:
	BCLR	#7,D2			ELSE KEY DEPRESSED
	SF	10(A0,D2.W)
	BRA.S	.1
.SET_KEY:
	ST	10(A0,D2.W)
	MOVE.B	D2,8(A0)
.1	BTST	#4,$FFFFFA01.W
	BEQ.S	AND_AG
VECTOREND:
	MOVE.L 	(SP)+,D2
	MOVE.L	(SP)+,A0
	RTE

JOY_PACKAGE1:
	MOVE.B 	D2,4(A0)
	CLR.W	(A0)
	BRA.S	AND_AG

JOY1:	ST	2(A0)
	BRA.S	AND_AG

JOY_PACKAGE2:
	MOVE.B 	D2,6(A0)
	CLR.W	2(A0)
	BRA.S	AND_AG
	
*********************
KEY_VARIABLES:
NEXT_JOY1:	DC.W	0
NEXT_JOY2:	DC.W	0
JBUFF0:		DC.W	0
JBUFF1:		DC.W	0
KBUFF:		DC.W	0
*********************

KEY_BUFFER	DS.B	128

***************************************************
* IN THE EVENT OF A SERIOUS INTERRUPT CRASH!!     *
***************************************************

SERIOUS_ERROR:
	MOVE.W	#$2700,SR
	MOVE.L	#200000,D0
.LOOP	ADDQ.W	#2,$FFFF8240.W
	SUBQ.L	#1,D0
	BNE.S	.LOOP
	BRA	QUIT

*************************************************
* THE VBL ROUTINE(S)                            *
*************************************************

NULL_VBL:
	TST.B	KEY_BUFFER+$1
	BNE	QUIT
	RTE

NULL_B:	RTE

**************************************************************************
* WRITE DATA TO KEYBOARD PROCESSOR. LIST IN A0
**************************************************************************

KEYBOARD_ON:	DC.B	$12,$14
KEYBOARD_OFF:	DC.B	$14,$8

IKBD:
	LEA 	$FFFFFC00.W,A1		WRITE TO THE KEYBOARD
IKLOOP	MOVE.B 	(A1),D1			PROCESSOR
	BTST 	#1,D1			READY TO RECIEVE DATA?
	BEQ.S 	IKLOOP
	MOVE.B 	(A0)+,2(A1)		SEND DATA
	DBF	D7,IKLOOP
	RTS

TEXT:	DC.B	$1B,$45,"                                 TITLE MUSIC",13,10
	DC.B	13,10
	DC.B	"                 From the game KILLING SPREE by TIM & DAVE MOSS",13,10
	DC.B	"               and STEFAN POSTHUMA better known as The LOST BOYS",13,10
	DC.B	13,10
	DC.B	"                This music is by Dave Moss and runs at 16Khz on",13,10
	DC.B	"                        a modified Quartet routine. ",13,10
	DC.B	13,10
	DC.B	"                    (C) COPYRIGHT LOST BOYS DEVELOPMENT 1991",13,10
	DC.B	0
	EVEN

	INCLUDE	F:\NEW_GAME\INTRO\Q_PLAYER.S

SONG_DATA:	INCBIN	F:\NEW_GAME\INTRO\KILLING2.4V
		EVEN
SET_DATA	INCBIN	F:\NEW_GAME\INTRO\FRAC.SET
		EVEN

	BSS

	DS.L	100
OURSTACK